#!/bin/bash

aembit_raw_prerouting_chain_name=aembit_raw_prerouting_chain
aembit_raw_output_chain_name=aembit_raw_output_chain
aembit_nat_output_chain_name=aembit_nat_output_chain
aembit_nat_prerouting_chain_name=aembit_nat_prerouting_chain
aembit_filter_input_chain_name=aembit_filter_input_chain

custom_chains=("raw,PREROUTING,$aembit_raw_prerouting_chain_name" "raw,OUTPUT,$aembit_raw_output_chain_name" "nat,OUTPUT,$aembit_nat_output_chain_name" "nat,PREROUTING,$aembit_nat_prerouting_chain_name" "filter,INPUT,$aembit_filter_input_chain_name")

for custom_chain in "${custom_chains[@]}"; do
    # Split to table, buildit chain and custom chain name
    IFS=',' read -r -a custom_chain_parts <<< "$custom_chain"

    table_name="${custom_chain_parts[0]}"
    builtin_chain_name="${custom_chain_parts[1]}"
    custom_chain_name="${custom_chain_parts[2]}"

    # Delete our chain reference from output chain
    iptables -t "$table_name" -D "$builtin_chain_name" -j "$custom_chain_name"

    # Delete all rules in our chain
    iptables -t "$table_name" -F "$custom_chain_name"

    # Delete custom chain
    iptables  -t "$table_name" -X "$custom_chain_name"
done
